-------------------
-- const
-------------------
UPDATE = 'Update';
WAIT_TIME = 0.02;

-------------------
-- ActorFrame
-------------------
-- MEMO:アクターは後に書いたものが上に描画される

return Def.ActorFrame{
    Name= "xtl_actor_a",

    Def.Quad{
        Name= "xtl_actor_base",
        InitCommand= cmd(visible,false;sleep,9999),
    },

    -- ループ背景動画 Rate変更する
    Def.Sprite{
        Name= "xtl_actor_video",
        Texture= "night_running.avi",
        OnCommand= function(self)

            --[[
                Ratesを更新
                @args (Beat位置)
            ]]
            function UpdateRates(beat)
                -- Rateループ
                for m, rates in ipairs(rates) do
                    if (beat >= rates[1] and lastBeat < rates[1]) then
                        video:rate(rates[2]);
                    elseif (beat < rates[1]) then
                        break
                    end
                end
                lastBeat = beat;
            end

            -- Rates Event
            rates = {
                {4.000, 1.0},
                {215.000, 0.700},
                {215.688, 2.000},
                {216.000, 4.000},
                {219.500, 0.500},
                {220.000, 0.500},
                {226.500, 0.700},
                {227.000, 0.800},
                {228.000, 1.000},
                {244.000, 1.600},
                {252.000, 2.200},
                {260.000, 3.000},
                {268.000, 4.000},
                {275.000, 1.600},
                {276.000, 0.900}
            }
            lastBeat = -16.0;
            video = self:GetTexture();
            local sizeRatio = SCREEN_HEIGHT/540.0;

            self:zoom(sizeRatio);
            self:x(SCREEN_CENTER_X);
            self:y(SCREEN_CENTER_Y);
            self:queuecommand(UPDATE);

        end,
        UpdateCommand= function(self)
            beat = GAMESTATE:GetSongBeat();
            UpdateRates(beat);
            self:sleep(WAIT_TIME);
            self:queuecommand(UPDATE);

        end,
    },

    -- タイトル文字画像
    Def.Sprite{
        Name= "xtl_actor_title",
        Texture= "title.png",
        OnCommand= function(self)
            local sizeRatio = SCREEN_HEIGHT/600.0;
            self:zoom(sizeRatio);
            self:x(SCREEN_CENTER_X);
            self:y(SCREEN_CENTER_Y);
            self:queuecommand(UPDATE);
        end,

        UpdateCommand= function(self)
            beat = GAMESTATE:GetSongBeat();

            if(54*4 < beat and beat < 54*4 + 3.75) then
                self:rotationz((beat - math.floor(beat))*360*4);
            elseif (54*4 + 3.75 <= beat and beat < 55*4+1) then
                self:rotationz(0);
            end

            self:sleep(WAIT_TIME);
            self:queuecommand(UPDATE);

        end,
    },

    -- タイトル文字のブレンド
    Def.Sprite {
        Name= "xtl_actor_blend",
        Texture= "title.png",
        OnCommand= function(self)
            local sizeRatio = SCREEN_HEIGHT/600.0;
            alpha = 1;
            self:blend(1);
            self:zoom(sizeRatio);
            self:x(SCREEN_CENTER_X);
            self:y(SCREEN_CENTER_Y);
            self:queuecommand(UPDATE);
        end,

        UpdateCommand= function(self)
            beat = GAMESTATE:GetSongBeat();

            if(54*4 < beat and beat < 54*4 + 3.75) then
                alpha = 0;
            else
                alpha = 1;
            end

            self:diffusealpha(alpha);
            self:rainbow();

            self:sleep(WAIT_TIME);
            self:queuecommand(UPDATE);

        end,
    },
}
